﻿package
{
	import flash.display.MovieClip;
	import flash.events.Event;
	
	public class GameObjectLayer extends MovieClip
	{
		private var _objects : Vector.<MovieClip>;
		
		public function GameObjectLayer()
		{
			_objects = new Vector.<MovieClip>();
			this.addEventListener(Event.ENTER_FRAME, handleEnterFrame);
		}
		
		public function reset() : void
		{
			for (var i : int = 0; i < _objects.length; i++)
			{
				this.removeChild(_objects[i]);
				//_objects.splice(i,1);
			}
			
			_objects = new Vector.<MovieClip>();
		}
		
		private function handleEnterFrame(e : Event) : void
		{
			checkObjectsPositionAndRemove();
		}
		
		private function checkObjectsPositionAndRemove() : void
		{
			for (var i : int = 0; i < _objects.length; i++)
			{
				if (_objects[i].x + _objects[i].width < 0)
				{
					this.removeChild(_objects[i]);
					_objects.splice(i,1);
				}
			}
		}
		
		public function addObject(object : MovieClip) : void
		{
			_objects.push(object);
			this.addChild(_objects[_objects.length-1]);
		}
		
		public function updateObjects(speed : Number) : void
		{
			for (var i : int = 0; i < _objects.length; i++)
			{
				_objects[i].x -= speed;
			}
		}
		
		public function get objects () : Vector.<MovieClip>
		{
			return _objects;
		}
	}

}