﻿package  
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	
	import com.freeactionscript.CollisionTest;
	
	import com.greensock.TweenLite;
	import com.greensock.easing.*;
	
	import flash.display.BitmapData;
	import flash.filters.BitmapFilterQuality;
	import flash.filters.BitmapFilter
	import flash.filters.BlurFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.filters.DisplacementMapFilterMode;
	import flash.geom.Point;

	public class Level extends MovieClip
	{
		public static const OBSTACLE_FREQUENCY_DEVIATION : Number = 1;
		
		public static const WIN : String = "win";
		public static const LOSE : String = "lose";

		private var _obstacleFrequenciesByPhase : Vector.<int> = Vector.<int>([8,6,5,4,10]);
		private var _phaseDurations : Vector.<int> = Vector.<int>([30,20,20,20,30]);
		
		public var player1_container_mc : PlayerContainer;
		public var player2_container_mc : PlayerContainer;
		
		private var _obstacleTimer : Timer;
		
		private var _collisionTest : CollisionTest;
		
		private var _main : Main;
		
		private var bm;  
		private var disp;  
		private var offsets;  
		
		private var frameRateDate : Date = new Date();
		
		private var _running : Boolean;
		
		private var _gamePhase : int = 0;
		
		private var _gameOverTimer : Timer;
		private var _phaseTimer : Timer;
		
		public var _obstacleFrequency : Number = 8; // Sekunden
		
		private var _gameOverStatus : String = LOSE;

		public function Level() 
		{
			super();
			
			_running = false;
			
			_gameOverTimer = new Timer(500,1);
			
			player1_container_mc.player_mc.init(Main.PLAYER1_TITLE, player1_container_mc, player2_container_mc.player_mc, this);
			player2_container_mc.player_mc.init(Main.PLAYER2_TITLE, player2_container_mc, player1_container_mc.player_mc, this);
			
			player1_container_mc.wave_layer_mc.wave_mc.gotoAndStop(Main.PLAYER1_TITLE);
			player2_container_mc.wave_layer_mc.wave_mc.gotoAndStop(Main.PLAYER2_TITLE);

			player1_container_mc.text_layer_mc.gotoAndStop(Main.PLAYER1_TITLE);
			player2_container_mc.text_layer_mc.gotoAndStop(Main.PLAYER2_TITLE);
			
			player1_container_mc.sun_moon_layer_mc.sun_moon_mc.gotoAndStop(Main.PLAYER1_TITLE);
			player2_container_mc.sun_moon_layer_mc.sun_moon_mc.gotoAndStop(Main.PLAYER2_TITLE);
			
			_gamePhase = 0;
			_obstacleTimer = new Timer(_obstacleFrequenciesByPhase[_gamePhase]*1000,0);
			_phaseTimer = new Timer(_phaseDurations[_gamePhase] * 1000,1);
			
			_collisionTest = new CollisionTest();
			
			//applyWaterEffect();
			
			addEventListeners();
		}
		
		public function init (main : Main) 
		{
			_main = main;
		}
		
		public function reset() : void
		{
			_obstacleTimer.reset();
			_obstacleTimer.stop();
			
			_running = false;
			_gamePhase = 0;
			
			player1_container_mc.reset();
			player2_container_mc.reset();
		}
		
		private function addEventListeners () : void
		{
			this.addEventListener(Event.ENTER_FRAME, handleEnterFrame);
			_obstacleTimer.addEventListener(TimerEvent.TIMER, handleTimer);
			_gameOverTimer.addEventListener(TimerEvent.TIMER, handleTimer);
			_phaseTimer.addEventListener(TimerEvent.TIMER, handleTimer);
		}
		
		private function handleEnterFrame(e : Event) : void
		{
			//trace(frameRateDate.time - new Date().time);
			//frameRateDate = new Date();

			/*trace(player1_container_mc.obstacle_layer_mc.objects.length);
			trace(player2_container_mc.obstacle_layer_mc.objects.length);
			trace(new Date());*/
			if (_main.currState == Main.LEVEL_STATE && _running)
			{
				player1_container_mc.update();
				player2_container_mc.update();
				
				checkCollisions();
			}
			//player1_container_mc.decoration_layer_mc.updateObjects(Main.SPEED/4);a
			//player2_container_mc.decoration_layer_mc.updateObjects(Main.SPEED/4);
			
			//updateWaterEffect();
		}
		
		private function handleTimer (e : TimerEvent) : void
		{
			if (e.currentTarget == _gameOverTimer)
			{
				_gameOverTimer.reset();
				_gameOverTimer.stop();
				_main.enterState(Main.GAME_OVER_STATE);
			}
			else if (e.currentTarget == _obstacleTimer)
			{
				if (_gamePhase < 5 && _running)
				{
					addObstacle();
					var newTimerDuration = _obstacleFrequenciesByPhase[_gamePhase] + 
											(-OBSTACLE_FREQUENCY_DEVIATION + (Math.random() * OBSTACLE_FREQUENCY_DEVIATION * 2));
					
					_obstacleTimer.delay = newTimerDuration*1000;
					_obstacleTimer.reset();
					_obstacleTimer.start();
				}
			}
			else if (e.currentTarget == _phaseTimer)
			{
				if (_gamePhase < 5 && _running)
				{
					_gamePhase++;
					_phaseTimer.delay = _phaseDurations[_gamePhase] * 1000;
					_phaseTimer.reset();
					_phaseTimer.start();
					
					player1_container_mc.text_layer_mc.showText(_gamePhase);
					player2_container_mc.text_layer_mc.showText(_gamePhase);
				}
				
			}
		}
		
		public function handleKeyUp (player : Player) : void
		{
			if (player.movementMode == Player.JUMPING && 
				player.y < Main.CONTAINER_HEIGHT - Main.JUMP_HEIGHT_REQUIRED_FOR_STOMP)
			{
				player.stomp();
				shakeScreen(player);
				
				if (player.title == Main.PLAYER1_TITLE)
				{
					player2_container_mc.moveUpWave();
				}
				else if (player.title == Main.PLAYER2_TITLE)
				{
					player1_container_mc.moveUpWave();
				}
			}
			else if (player.movementMode == Player.WALKING)
			{
				player.jump();
			}
		}
		
		private function checkCollisions() : void
		{
			var i : int = 0;
			var objects : Vector.<MovieClip> = player1_container_mc.obstacle_layer_mc.objects;
			var player : Player = player1_container_mc.player_mc;
			
			for (i = 0; i < objects.length; i++)
			{
				if (_collisionTest.complex(player, objects[i]))
				{
					player1_container_mc.player_mc.fall();
					player2_container_mc.player_mc.fall();
					
					_obstacleTimer.stop();
					
					_gameOverStatus = LOSE;
					_gameOverTimer.delay = 500;
					_gameOverTimer.start();
					//_main.enterState(Main.GAME_OVER_STATE);
				}
			}
			
			objects = player2_container_mc.obstacle_layer_mc.objects;
			player = player2_container_mc.player_mc;
			
			for (i = 0; i < objects.length; i++)
			{
				// code from http://www.freeactionscript.com/2011/08/as3-pixel-perfect-collision-detection/
				if (_collisionTest.complex(player, objects[i]))
				{
					player1_container_mc.player_mc.fall();
					player2_container_mc.player_mc.fall();
					
					_obstacleTimer.stop();
					
					_gameOverStatus = LOSE;
					_gameOverTimer.delay = 500;
					_gameOverTimer.start();
					//_main.enterState(Main.GAME_OVER_STATE);
				}
			}
		}
		
		public function addObstacle () : void
		{
			//var obstacleHeight : Number = Main.OBSTACLE_MIN_HEIGHT + ((Main.OBSTACLE_MAX_HEIGHT - Main.OBSTACLE_MIN_HEIGHT) * Math.random());
			var container : PlayerContainer;
			
			if (Math.random() > 0.5)
			{
				container = player1_container_mc;
			}
			else
			{
				container = player2_container_mc;
			}
			
			/*var obstacle : Obstacle = new Obstacle(container.width, Main.CONTAINER_HEIGHT, 20, obstacleHeight);
			container.obstacle_layer_mc.addObject(obstacle);*/
			
			
			var obstacle : Obstacle
			var randomValue : Number = Math.random();
			
			if (_gamePhase == 0)
			{
				obstacle = new ObstacleEasy();
			}
			else if (_gamePhase == 1)
			{
				if (randomValue < 0.3)
				{
					obstacle = new ObstacleMedium();
				}
				else
				{
					obstacle = new ObstacleEasy();
				}
			}
			else if (_gamePhase == 2)
			{
				if (randomValue < 0.2)
				{
					obstacle = new ObstacleHard();
				}
				else if (randomValue < 0.6)
				{
					obstacle = new ObstacleMedium();
				}
				else
				{
					obstacle = new ObstacleEasy();
				}
			}
			else if (_gamePhase == 3)
			{
				if (randomValue < 0.3)
				{
					obstacle = new ObstacleHard();
				}
				else if (randomValue < 0.8)
				{
					obstacle = new ObstacleMedium();
				}
				else
				{
					obstacle = new ObstacleEasy();
				}
			}
			else if (_gamePhase == 4)
			{
				obstacle = new ObstacleSuperHard();
			}

			if (_gamePhase < 4)
			{
				obstacle.x = container.width;
				obstacle.y = Main.CONTAINER_HEIGHT;
				container.obstacle_layer_mc.addObject(obstacle);
			}
			else
			{
				var wave1 : Obstacle = new ObstacleSuperHard();
				var wave2 : Obstacle = new ObstacleSuperHard();
				wave1.x = container.width;
				wave1.y = Main.CONTAINER_HEIGHT + 10;
				wave2.x = container.width;
				wave2.y = Main.CONTAINER_HEIGHT + 10;
				player1_container_mc.obstacle_layer_mc.addObject(wave1);
				player2_container_mc.obstacle_layer_mc.addObject(wave2);
				
				_gameOverStatus = WIN;
				_gameOverTimer.delay = 9500;
				_gameOverTimer.start();
			}
		}
		
		public function shakeScreen(player : Player) : void
		{
			if (player.title == Main.PLAYER1_TITLE)
			{
				shakeTween();
			}
			else
			{
				shakeTween();
			}
		}
		
		// code from http://rhuno.com/flashblog/2010/04/29/realistic-water-effect/
		private function applyWaterEffect() : void 
		{
			bm = new BitmapData(player2_container_mc.width, player2_container_mc.height);  
			disp  = new DisplacementMapFilter(bm,new Point(0,0),10,20,2,2, DisplacementMapFilterMode.CLAMP);  
			offsets  = [new Point(0, 0), new Point(0, 0)];  
		}
		
		// code from http://rhuno.com/flashblog/2010/04/29/realistic-water-effect/
		private function updateWaterEffect() : void
		{
			/*var blurX:Number;
			
			if (player2_container_mc.filters)
			
			var blurX:Number = 4;
			var blurY:Number = 0;
			var blurFilter : BlurFilter = new BlurFilter(blurX, blurY, BitmapFilterQuality.HIGH);
			player2_container_mc.filters = [blurFilter];
			
			offsets[0].x -=10;  
			offsets[1].y -=0;  
			bm.perlinNoise(12, 60, 1 ,2, true, true, 2, true, offsets);  
			player2_container_mc.filters=[disp];  */
			
			offsets[0].x -=10;  
			offsets[1].y -=0;  
			bm.perlinNoise(200, 960, 1 ,2, true, true, 2, true, offsets);  
			player2_container_mc.filters=[disp];
		}
		
		// code from https://greensock.com/forums/topic/6153-shake-effect/
		function shakeTween():void
		{
			TweenLite.to(this, 0.1, {
			y: -10,
			ease: Quad.easeInOut
		  });
		TweenLite.to(this, 0.1, {
			repeat: 4,
			y: 10,
			yoyo: true,
			delay: 0.1,
			ease: Quad.easeInOut
		  });
		TweenLite.to(this, 0.1, {
			y: 0,
			delay: 0.1 * 4
		  });
		}
		
		public function set running (value : Boolean) : void
		{
			_running = value;
			
			if (running)
			{
				_obstacleTimer.start();
				_phaseTimer.start();
				player1_container_mc.text_layer_mc.showText(_gamePhase);
				player2_container_mc.text_layer_mc.showText(_gamePhase);
			}
			else
			{
				_obstacleTimer.stop();
				_phaseTimer.stop();
			}
		}
		
		public function get running () : Boolean
		{
			return _running;
		}
		
		public function get gameOverStatus () : String
		{
			return _gameOverStatus;
		}
	}
}
