/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Ray;
import com.jogamp.opengl.math.Vert2fImmutable;
import java.util.ArrayList;

public final class VectorUtil {
    public static final float[] VEC3_ONE = new float[]{1.0f, 1.0f, 1.0f};
    public static final float[] VEC3_ZERO = new float[]{0.0f, 0.0f, 0.0f};
    public static final float[] VEC3_UNIT_Y = new float[]{0.0f, 1.0f, 0.0f};
    public static final float[] VEC3_UNIT_Y_NEG = new float[]{0.0f, -1.0f, 0.0f};
    public static final float[] VEC3_UNIT_Z = new float[]{0.0f, 0.0f, 1.0f};
    public static final float[] VEC3_UNIT_Z_NEG = new float[]{0.0f, 0.0f, -1.0f};

    public static float[] copyVec2(float[] fArray, int n, float[] fArray2, int n2) {
        System.arraycopy(fArray2, n2, fArray, n, 2);
        return fArray;
    }

    public static float[] copyVec3(float[] fArray, int n, float[] fArray2, int n2) {
        System.arraycopy(fArray2, n2, fArray, n, 3);
        return fArray;
    }

    public static float[] copyVec4(float[] fArray, int n, float[] fArray2, int n2) {
        System.arraycopy(fArray2, n2, fArray, n, 4);
        return fArray;
    }

    public static boolean isVec2Equal(float[] fArray, int n, float[] fArray2, int n2) {
        return FloatUtil.isEqual(fArray[0 + n], fArray2[0 + n2]) && FloatUtil.isEqual(fArray[1 + n], fArray2[1 + n2]);
    }

    public static boolean isVec3Equal(float[] fArray, int n, float[] fArray2, int n2) {
        return FloatUtil.isEqual(fArray[0 + n], fArray2[0 + n2]) && FloatUtil.isEqual(fArray[1 + n], fArray2[1 + n2]) && FloatUtil.isEqual(fArray[2 + n], fArray2[2 + n2]);
    }

    public static boolean isVec2Equal(float[] fArray, int n, float[] fArray2, int n2, float f) {
        return FloatUtil.isEqual(fArray[0 + n], fArray2[0 + n2], f) && FloatUtil.isEqual(fArray[1 + n], fArray2[1 + n2], f);
    }

    public static boolean isVec3Equal(float[] fArray, int n, float[] fArray2, int n2, float f) {
        return FloatUtil.isEqual(fArray[0 + n], fArray2[0 + n2], f) && FloatUtil.isEqual(fArray[1 + n], fArray2[1 + n2], f) && FloatUtil.isEqual(fArray[2 + n], fArray2[2 + n2], f);
    }

    public static boolean isVec2Zero(float[] fArray, int n) {
        return 0.0f == fArray[0 + n] && 0.0f == fArray[1 + n];
    }

    public static boolean isVec3Zero(float[] fArray, int n) {
        return 0.0f == fArray[0 + n] && 0.0f == fArray[1 + n] && 0.0f == fArray[2 + n];
    }

    public static boolean isVec2Zero(float[] fArray, int n, float f) {
        return VectorUtil.isZero(fArray[0 + n], fArray[1 + n], f);
    }

    public static boolean isVec3Zero(float[] fArray, int n, float f) {
        return VectorUtil.isZero(fArray[0 + n], fArray[1 + n], fArray[2 + n], f);
    }

    public static boolean isZero(float f, float f2, float f3) {
        return FloatUtil.isZero(f, f3) && FloatUtil.isZero(f2, f3);
    }

    public static boolean isZero(float f, float f2, float f3, float f4) {
        return FloatUtil.isZero(f, f4) && FloatUtil.isZero(f2, f4) && FloatUtil.isZero(f3, f4);
    }

    public static float distSquareVec3(float[] fArray, float[] fArray2) {
        float f = fArray[0] - fArray2[0];
        float f2 = fArray[1] - fArray2[1];
        float f3 = fArray[2] - fArray2[2];
        return f * f + f2 * f2 + f3 * f3;
    }

    public static float distVec3(float[] fArray, float[] fArray2) {
        return FloatUtil.sqrt(VectorUtil.distSquareVec3(fArray, fArray2));
    }

    public static float dotVec3(float[] fArray, float[] fArray2) {
        return fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2];
    }

    public static float cosAngleVec3(float[] fArray, float[] fArray2) {
        return VectorUtil.dotVec3(fArray, fArray2) / (VectorUtil.normVec3(fArray) * VectorUtil.normVec3(fArray2));
    }

    public static float angleVec3(float[] fArray, float[] fArray2) {
        return FloatUtil.acos(VectorUtil.cosAngleVec3(fArray, fArray2));
    }

    public static float normSquareVec2(float[] fArray) {
        return fArray[0] * fArray[0] + fArray[1] * fArray[1];
    }

    public static float normSquareVec2(float[] fArray, int n) {
        float f = fArray[0 + n];
        float f2 = f * f;
        f = fArray[1 + n];
        return f2 + f * f;
    }

    public static float normSquareVec3(float[] fArray) {
        return fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2];
    }

    public static float normSquareVec3(float[] fArray, int n) {
        float f = fArray[0 + n];
        float f2 = f * f;
        f = fArray[1 + n];
        f2 += f * f;
        f = fArray[2 + n];
        return f2 + f * f;
    }

    public static float normVec2(float[] fArray) {
        return FloatUtil.sqrt(VectorUtil.normSquareVec2(fArray));
    }

    public static float normVec3(float[] fArray) {
        return FloatUtil.sqrt(VectorUtil.normSquareVec3(fArray));
    }

    public static float[] normalizeVec2(float[] fArray, float[] fArray2) {
        float f = VectorUtil.normSquareVec2(fArray2);
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
        } else {
            float f2 = 1.0f / FloatUtil.sqrt(f);
            fArray[0] = fArray2[0] * f2;
            fArray[1] = fArray2[1] * f2;
        }
        return fArray;
    }

    public static float[] normalizeVec2(float[] fArray) {
        float f = VectorUtil.normSquareVec2(fArray);
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
        } else {
            float f2 = 1.0f / FloatUtil.sqrt(f);
            fArray[0] = fArray[0] * f2;
            fArray[1] = fArray[1] * f2;
        }
        return fArray;
    }

    public static float[] normalizeVec3(float[] fArray, float[] fArray2) {
        float f = VectorUtil.normSquareVec3(fArray2);
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
        } else {
            float f2 = 1.0f / FloatUtil.sqrt(f);
            fArray[0] = fArray2[0] * f2;
            fArray[1] = fArray2[1] * f2;
            fArray[2] = fArray2[2] * f2;
        }
        return fArray;
    }

    public static float[] normalizeVec3(float[] fArray) {
        float f = VectorUtil.normSquareVec3(fArray);
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
        } else {
            float f2 = 1.0f / FloatUtil.sqrt(f);
            fArray[0] = fArray[0] * f2;
            fArray[1] = fArray[1] * f2;
            fArray[2] = fArray[2] * f2;
        }
        return fArray;
    }

    public static float[] normalizeVec3(float[] fArray, int n) {
        float f = VectorUtil.normSquareVec3(fArray, n);
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            fArray[0 + n] = 0.0f;
            fArray[1 + n] = 0.0f;
            fArray[2 + n] = 0.0f;
        } else {
            float f2 = 1.0f / FloatUtil.sqrt(f);
            int n2 = 0 + n;
            fArray[n2] = fArray[n2] * f2;
            int n3 = 1 + n;
            fArray[n3] = fArray[n3] * f2;
            int n4 = 2 + n;
            fArray[n4] = fArray[n4] * f2;
        }
        return fArray;
    }

    public static float[] scaleVec2(float[] fArray, float[] fArray2, float f) {
        fArray[0] = fArray2[0] * f;
        fArray[1] = fArray2[1] * f;
        return fArray;
    }

    public static float[] scaleVec3(float[] fArray, float[] fArray2, float f) {
        fArray[0] = fArray2[0] * f;
        fArray[1] = fArray2[1] * f;
        fArray[2] = fArray2[2] * f;
        return fArray;
    }

    public static float[] scaleVec3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0];
        fArray[1] = fArray2[1] * fArray3[1];
        fArray[2] = fArray2[2] * fArray3[2];
        return fArray;
    }

    public static float[] scaleVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0];
        fArray[1] = fArray2[1] * fArray3[1];
        return fArray;
    }

    public static float[] divVec2(float[] fArray, float[] fArray2, float f) {
        fArray[0] = fArray2[0] / f;
        fArray[1] = fArray2[1] / f;
        return fArray;
    }

    public static float[] divVec3(float[] fArray, float[] fArray2, float f) {
        fArray[0] = fArray2[0] / f;
        fArray[1] = fArray2[1] / f;
        fArray[2] = fArray2[2] / f;
        return fArray;
    }

    public static float[] divVec3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] / fArray3[0];
        fArray[1] = fArray2[1] / fArray3[1];
        fArray[2] = fArray2[2] / fArray3[2];
        return fArray;
    }

    public static float[] divVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] / fArray3[0];
        fArray[1] = fArray2[1] / fArray3[1];
        return fArray;
    }

    public static float[] addVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] + fArray3[0];
        fArray[1] = fArray2[1] + fArray3[1];
        return fArray;
    }

    public static float[] addVec3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] + fArray3[0];
        fArray[1] = fArray2[1] + fArray3[1];
        fArray[2] = fArray2[2] + fArray3[2];
        return fArray;
    }

    public static float[] subVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] - fArray3[0];
        fArray[1] = fArray2[1] - fArray3[1];
        return fArray;
    }

    public static float[] subVec3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] - fArray3[0];
        fArray[1] = fArray2[1] - fArray3[1];
        fArray[2] = fArray2[2] - fArray3[2];
        return fArray;
    }

    public static float[] crossVec3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[1] * fArray3[2] - fArray2[2] * fArray3[1];
        fArray[1] = fArray2[2] * fArray3[0] - fArray2[0] * fArray3[2];
        fArray[2] = fArray2[0] * fArray3[1] - fArray2[1] * fArray3[0];
        return fArray;
    }

    public static float[] crossVec3(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        fArray[0 + n] = fArray2[1 + n2] * fArray3[2 + n3] - fArray2[2 + n2] * fArray3[1 + n3];
        fArray[1 + n] = fArray2[2 + n2] * fArray3[0 + n3] - fArray2[0 + n2] * fArray3[2 + n3];
        fArray[2 + n] = fArray2[0 + n2] * fArray3[1 + n3] - fArray2[1 + n2] * fArray3[0 + n3];
        return fArray;
    }

    public static float[] mulColMat4Vec3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray3[0] * fArray2[0] + fArray3[1] * fArray2[4] + fArray3[2] * fArray2[8] + fArray2[12];
        fArray[1] = fArray3[0] * fArray2[1] + fArray3[1] * fArray2[5] + fArray3[2] * fArray2[9] + fArray2[13];
        fArray[2] = fArray3[0] * fArray2[2] + fArray3[1] * fArray2[6] + fArray3[2] * fArray2[10] + fArray2[14];
        return fArray;
    }

    public static float[] mulRowMat4Vec3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1] + fArray3[2] * fArray2[2] + fArray2[3];
        fArray[1] = fArray3[0] * fArray2[4] + fArray3[1] * fArray2[5] + fArray3[2] * fArray2[6] + fArray2[7];
        fArray[2] = fArray3[0] * fArray2[8] + fArray3[1] * fArray2[9] + fArray3[2] * fArray2[10] + fArray2[11];
        return fArray;
    }

    public static float mid(float f, float f2) {
        return (f + f2) * 0.5f;
    }

    public static float[] midVec3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = (fArray2[0] + fArray3[0]) * 0.5f;
        fArray[1] = (fArray2[1] + fArray3[1]) * 0.5f;
        fArray[2] = (fArray2[2] + fArray3[2]) * 0.5f;
        return fArray;
    }

    public static float determinantVec3(float[] fArray, float[] fArray2, float[] fArray3) {
        return fArray[0] * fArray2[1] * fArray3[2] + fArray[1] * fArray2[2] * fArray3[0] + fArray[2] * fArray2[0] * fArray3[1] - fArray[0] * fArray2[2] * fArray3[1] - fArray[1] * fArray2[0] * fArray3[2] - fArray[2] * fArray2[1] * fArray3[0];
    }

    public static boolean isCollinearVec3(float[] fArray, float[] fArray2, float[] fArray3) {
        return FloatUtil.isZero(VectorUtil.determinantVec3(fArray, fArray2, fArray3), 1.1920929E-7f);
    }

    public static boolean isInCircleVec2(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4 = vert2fImmutable.getCoord();
        return (fArray4[0] * fArray4[0] + fArray4[1] * fArray4[1]) * VectorUtil.triAreaVec2(fArray3 = vert2fImmutable2.getCoord(), fArray2 = vert2fImmutable3.getCoord(), fArray = vert2fImmutable4.getCoord()) - (fArray3[0] * fArray3[0] + fArray3[1] * fArray3[1]) * VectorUtil.triAreaVec2(fArray4, fArray2, fArray) + (fArray2[0] * fArray2[0] + fArray2[1] * fArray2[1]) * VectorUtil.triAreaVec2(fArray4, fArray3, fArray) - (fArray[0] * fArray[0] + fArray[1] * fArray[1]) * VectorUtil.triAreaVec2(fArray4, fArray3, fArray2) > 0.0f;
    }

    public static float triAreaVec2(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3) {
        float[] fArray = vert2fImmutable.getCoord();
        float[] fArray2 = vert2fImmutable2.getCoord();
        float[] fArray3 = vert2fImmutable3.getCoord();
        return (fArray2[0] - fArray[0]) * (fArray3[1] - fArray[1]) - (fArray2[1] - fArray[1]) * (fArray3[0] - fArray[0]);
    }

    public static float triAreaVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        return (fArray2[0] - fArray[0]) * (fArray3[1] - fArray[1]) - (fArray2[1] - fArray[1]) * (fArray3[0] - fArray[0]);
    }

    public static boolean isInTriangleVec3(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, float[] fArray7) {
        VectorUtil.subVec3(fArray5, fArray3, fArray);
        VectorUtil.subVec3(fArray6, fArray2, fArray);
        VectorUtil.subVec3(fArray7, fArray4, fArray);
        float f = VectorUtil.dotVec3(fArray5, fArray5);
        float f2 = VectorUtil.dotVec3(fArray5, fArray6);
        float f3 = VectorUtil.dotVec3(fArray6, fArray6);
        float f4 = VectorUtil.dotVec3(fArray5, fArray7);
        float f5 = VectorUtil.dotVec3(fArray6, fArray7);
        float f6 = 1.0f / (f * f3 - f2 * f2);
        float f7 = (f3 * f4 - f2 * f5) * f6;
        float f8 = (f * f5 - f2 * f4) * f6;
        return f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f;
    }

    public static boolean isVec3InTriangle3(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, float[] fArray7, float[] fArray8, float[] fArray9) {
        VectorUtil.subVec3(fArray7, fArray3, fArray);
        VectorUtil.subVec3(fArray8, fArray2, fArray);
        float f = VectorUtil.dotVec3(fArray7, fArray7);
        float f2 = VectorUtil.dotVec3(fArray7, fArray8);
        float f3 = VectorUtil.dotVec3(fArray8, fArray8);
        float f4 = 1.0f / (f * f3 - f2 * f2);
        VectorUtil.subVec3(fArray9, fArray4, fArray);
        float f5 = VectorUtil.dotVec3(fArray7, fArray9);
        float f6 = VectorUtil.dotVec3(fArray8, fArray9);
        float f7 = (f3 * f5 - f2 * f6) * f4;
        float f8 = (f * f6 - f2 * f5) * f4;
        if (f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f) {
            return true;
        }
        VectorUtil.subVec3(fArray9, fArray4, fArray);
        f5 = VectorUtil.dotVec3(fArray7, fArray9);
        f6 = VectorUtil.dotVec3(fArray8, fArray9);
        f7 = (f3 * f5 - f2 * f6) * f4;
        f8 = (f * f6 - f2 * f5) * f4;
        if (f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f) {
            return true;
        }
        VectorUtil.subVec3(fArray9, fArray5, fArray);
        f5 = VectorUtil.dotVec3(fArray7, fArray9);
        f6 = VectorUtil.dotVec3(fArray8, fArray9);
        f7 = (f3 * f5 - f2 * f6) * f4;
        f8 = (f * f6 - f2 * f5) * f4;
        return f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f;
    }

    public static boolean isVec3InTriangle3(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, float[] fArray7, float[] fArray8, float[] fArray9, float f) {
        VectorUtil.subVec3(fArray7, fArray3, fArray);
        VectorUtil.subVec3(fArray8, fArray2, fArray);
        float f2 = VectorUtil.dotVec3(fArray7, fArray7);
        float f3 = VectorUtil.dotVec3(fArray7, fArray8);
        float f4 = VectorUtil.dotVec3(fArray8, fArray8);
        float f5 = 1.0f / (f2 * f4 - f3 * f3);
        VectorUtil.subVec3(fArray9, fArray4, fArray);
        float f6 = VectorUtil.dotVec3(fArray7, fArray9);
        float f7 = VectorUtil.dotVec3(fArray8, fArray9);
        float f8 = (f4 * f6 - f3 * f7) * f5;
        float f9 = (f2 * f7 - f3 * f6) * f5;
        if (FloatUtil.compare(f8, 0.0f, f) >= 0 && FloatUtil.compare(f9, 0.0f, f) >= 0 && FloatUtil.compare(f8 + f9, 1.0f, f) < 0) {
            return true;
        }
        VectorUtil.subVec3(fArray9, fArray4, fArray);
        f6 = VectorUtil.dotVec3(fArray7, fArray9);
        f7 = VectorUtil.dotVec3(fArray8, fArray9);
        f8 = (f4 * f6 - f3 * f7) * f5;
        f9 = (f2 * f7 - f3 * f6) * f5;
        if (FloatUtil.compare(f8, 0.0f, f) >= 0 && FloatUtil.compare(f9, 0.0f, f) >= 0 && FloatUtil.compare(f8 + f9, 1.0f, f) < 0) {
            return true;
        }
        VectorUtil.subVec3(fArray9, fArray5, fArray);
        f6 = VectorUtil.dotVec3(fArray7, fArray9);
        f7 = VectorUtil.dotVec3(fArray8, fArray9);
        f8 = (f4 * f6 - f3 * f7) * f5;
        f9 = (f2 * f7 - f3 * f6) * f5;
        return FloatUtil.compare(f8, 0.0f, f) >= 0 && FloatUtil.compare(f9, 0.0f, f) >= 0 && FloatUtil.compare(f8 + f9, 1.0f, f) < 0;
    }

    public static boolean ccw(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3) {
        return VectorUtil.triAreaVec2(vert2fImmutable, vert2fImmutable2, vert2fImmutable3) > 0.0f;
    }

    public static Winding getWinding(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3) {
        return VectorUtil.triAreaVec2(vert2fImmutable, vert2fImmutable2, vert2fImmutable3) > 0.0f ? Winding.CCW : Winding.CW;
    }

    public static float area(ArrayList<? extends Vert2fImmutable> arrayList) {
        int n = arrayList.size();
        float f = 0.0f;
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            float[] fArray = arrayList.get(n2).getCoord();
            float[] fArray2 = arrayList.get(n3).getCoord();
            f += fArray[0] * fArray2[1] - fArray2[0] * fArray[1];
            n2 = n3++;
        }
        return f;
    }

    public static Winding getWinding(ArrayList<? extends Vert2fImmutable> arrayList) {
        return VectorUtil.area(arrayList) >= 0.0f ? Winding.CCW : Winding.CW;
    }

    public static float[] getNormalVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        VectorUtil.subVec2(fArray, fArray3, fArray2);
        float f = fArray[0];
        fArray[0] = -fArray[1];
        fArray[1] = f;
        return VectorUtil.normalizeVec2(fArray);
    }

    public static float[] getNormalVec3(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6) {
        VectorUtil.subVec3(fArray5, fArray3, fArray2);
        VectorUtil.subVec3(fArray6, fArray4, fArray2);
        return VectorUtil.normalizeVec3(VectorUtil.crossVec3(fArray, fArray5, fArray6));
    }

    public static float[] getPlaneVec3(float[] fArray, float[] fArray2, float[] fArray3) {
        System.arraycopy(fArray2, 0, fArray, 0, 3);
        fArray[3] = -VectorUtil.dotVec3(fArray2, fArray3);
        return fArray;
    }

    public static float[] getPlaneVec3(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6) {
        VectorUtil.getNormalVec3(fArray, fArray2, fArray3, fArray4, fArray5, fArray6);
        fArray[3] = -VectorUtil.dotVec3(fArray, fArray2);
        return fArray;
    }

    public static float[] line2PlaneIntersection(float[] fArray, Ray ray, float[] fArray2, float f) {
        float f2 = VectorUtil.dotVec3(ray.dir, fArray2);
        if (Math.abs(f2) < f) {
            return null;
        }
        VectorUtil.scaleVec3(fArray, ray.dir, -(VectorUtil.dotVec3(ray.orig, fArray2) + fArray2[3]) / f2);
        return VectorUtil.addVec3(fArray, fArray, ray.orig);
    }

    public static float[] seg2SegIntersection(float[] fArray, Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        float f = (vert2fImmutable.getX() - vert2fImmutable2.getX()) * (vert2fImmutable3.getY() - vert2fImmutable4.getY()) - (vert2fImmutable.getY() - vert2fImmutable2.getY()) * (vert2fImmutable3.getX() - vert2fImmutable4.getX());
        if (f == 0.0f) {
            return null;
        }
        float f2 = vert2fImmutable.getX() * vert2fImmutable2.getY() - vert2fImmutable.getY() * vert2fImmutable2.getX();
        float f3 = vert2fImmutable3.getX() * vert2fImmutable4.getY() - vert2fImmutable3.getY() * vert2fImmutable4.getY();
        float f4 = ((vert2fImmutable3.getX() - vert2fImmutable4.getX()) * f2 - (vert2fImmutable.getX() - vert2fImmutable2.getX()) * f3) / f;
        float f5 = ((vert2fImmutable3.getY() - vert2fImmutable4.getY()) * f2 - (vert2fImmutable.getY() - vert2fImmutable2.getY()) * f3) / f;
        float f6 = (f4 - vert2fImmutable.getX()) / (vert2fImmutable2.getX() - vert2fImmutable.getX());
        float f7 = (f4 - vert2fImmutable3.getX()) / (vert2fImmutable4.getX() - vert2fImmutable3.getX());
        if (f6 <= 0.0f || f6 >= 1.0f) {
            return null;
        }
        if (f7 <= 0.0f || f7 >= 1.0f) {
            return null;
        }
        fArray[0] = f4;
        fArray[1] = f5;
        fArray[2] = 0.0f;
        return fArray;
    }

    public static boolean testSeg2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4 = vert2fImmutable.getCoord();
        float f = (fArray4[0] - (fArray3 = vert2fImmutable2.getCoord())[0]) * ((fArray2 = vert2fImmutable3.getCoord())[1] - (fArray = vert2fImmutable4.getCoord())[1]) - (fArray4[1] - fArray3[1]) * (fArray2[0] - fArray[0]);
        if (f == 0.0f) {
            return false;
        }
        float f2 = fArray4[0] * fArray3[1] - fArray4[1] * fArray3[0];
        float f3 = fArray2[0] * fArray[1] - fArray2[1] * fArray[1];
        float f4 = ((fArray2[0] - fArray[0]) * f2 - (fArray4[0] - fArray3[0]) * f3) / f;
        float f5 = (f4 - fArray4[0]) / (fArray3[0] - fArray4[0]);
        float f6 = (f4 - fArray2[0]) / (fArray[0] - fArray2[0]);
        return !(f5 <= 0.0f || f5 >= 1.0f || f6 <= 0.0f) && !(f6 >= 1.0f);
    }

    public static boolean testSeg2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4, float f) {
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4 = vert2fImmutable.getCoord();
        float f2 = (fArray4[0] - (fArray3 = vert2fImmutable2.getCoord())[0]) * ((fArray2 = vert2fImmutable3.getCoord())[1] - (fArray = vert2fImmutable4.getCoord())[1]) - (fArray4[1] - fArray3[1]) * (fArray2[0] - fArray[0]);
        if (FloatUtil.isZero(f2, f)) {
            return false;
        }
        float f3 = fArray4[0] * fArray3[1] - fArray4[1] * fArray3[0];
        float f4 = fArray2[0] * fArray[1] - fArray2[1] * fArray[1];
        float f5 = ((fArray2[0] - fArray[0]) * f3 - (fArray4[0] - fArray3[0]) * f4) / f2;
        float f6 = (f5 - fArray4[0]) / (fArray3[0] - fArray4[0]);
        float f7 = (f5 - fArray2[0]) / (fArray[0] - fArray2[0]);
        if (FloatUtil.compare(f6, 0.0f, f) <= 0 || FloatUtil.compare(f6, 1.0f, f) >= 0 || FloatUtil.compare(f7, 0.0f, f) <= 0 || FloatUtil.compare(f7, 1.0f, f) >= 0) {
            return false;
        }
        return !(f6 <= 0.0f || f6 >= 1.0f || f7 <= 0.0f) && !(f7 >= 1.0f);
    }

    public static float[] line2lineIntersection(float[] fArray, Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        float f = (vert2fImmutable.getX() - vert2fImmutable2.getX()) * (vert2fImmutable3.getY() - vert2fImmutable4.getY()) - (vert2fImmutable.getY() - vert2fImmutable2.getY()) * (vert2fImmutable3.getX() - vert2fImmutable4.getX());
        if (f == 0.0f) {
            return null;
        }
        float f2 = vert2fImmutable.getX() * vert2fImmutable2.getY() - vert2fImmutable.getY() * vert2fImmutable2.getX();
        float f3 = vert2fImmutable3.getX() * vert2fImmutable4.getY() - vert2fImmutable3.getY() * vert2fImmutable4.getY();
        float f4 = ((vert2fImmutable3.getX() - vert2fImmutable4.getX()) * f2 - (vert2fImmutable.getX() - vert2fImmutable2.getX()) * f3) / f;
        float f5 = ((vert2fImmutable3.getY() - vert2fImmutable4.getY()) * f2 - (vert2fImmutable.getY() - vert2fImmutable2.getY()) * f3) / f;
        fArray[0] = f4;
        fArray[1] = f5;
        fArray[2] = 0.0f;
        return fArray;
    }

    public static boolean testTri2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4, Vert2fImmutable vert2fImmutable5) {
        return VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable2, vert2fImmutable4, vert2fImmutable5) || VectorUtil.testSeg2SegIntersection(vert2fImmutable2, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5) || VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5);
    }

    public static boolean testTri2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4, Vert2fImmutable vert2fImmutable5, float f) {
        return VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable2, vert2fImmutable4, vert2fImmutable5, f) || VectorUtil.testSeg2SegIntersection(vert2fImmutable2, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5, f) || VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5, f);
    }

    public static enum Winding {
        CW(-1),
        CCW(1);

        public final int dir;

        private Winding(int n2) {
            this.dir = n2;
        }
    }
}

