/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;

public class PIXEL_SPACE_181028b
extends PApplet {
    int space_width = 1;
    int space_height = 1;
    int space_grid_multiplier = 4;
    int text_box_height = 50;
    int text_box_padding = 30;
    int crosshair_padding = 10;
    int crosshair_length = 5;
    int crosshair_weight = 4;
    int text_color = this.color(255, 255, 255);
    int[][] space = new int[this.space_width][this.space_height];
    Boolean[][] space_explored = new Boolean[this.space_width][this.space_height];
    int EMPTY = 0;
    int SUN = 1;
    int HOME = 2;
    int BLACK_HOLE = 3;
    String current_text = "Welcome to PIXEL-SPACE. Find your way back home by clicking on the map";
    Boolean game_over = false;

    public void setup() {
        this.space_width = this.width / this.space_grid_multiplier;
        this.space_height = (this.height - this.text_box_height) / this.space_grid_multiplier;
        this.space = new int[this.space_width][this.space_height];
        this.space_explored = new Boolean[this.space_width][this.space_height];
        this.fill(0);
        this.noStroke();
        this.noCursor();
        this.fillSpace();
    }

    public void draw() {
        this.background(0);
        int i = 0;
        while (i < this.space_width) {
            int j = 0;
            while (j < this.space_height) {
                if (this.space_explored[i][j].booleanValue()) {
                    this.fill(this.getSpaceColor(this.space[i][j]));
                    this.rect(i * this.space_grid_multiplier, j * this.space_grid_multiplier, this.space_grid_multiplier, this.space_grid_multiplier);
                }
                ++j;
            }
            ++i;
        }
        this.fill(0);
        this.stroke(255);
        this.line(0.0f, this.height - this.text_box_height, this.width, this.height - this.text_box_height);
        this.noStroke();
        this.fill(this.text_color);
        this.textSize(12.0f);
        this.text(this.current_text, this.text_box_padding, this.height - this.text_box_height + this.text_box_padding);
        this.fill(255);
        this.drawCursor();
        this.fill(0);
    }

    public void mouseClicked() {
        if (this.game_over.booleanValue()) {
            this.restart();
        } else if (this.mouseY < this.height - this.text_box_height - this.space_grid_multiplier && !this.space_explored[this.mouseX / this.space_grid_multiplier][this.mouseY / this.space_grid_multiplier].booleanValue()) {
            this.space_explored[this.mouseX / this.space_grid_multiplier][this.mouseY / this.space_grid_multiplier] = true;
            this.updateSpaceText(this.space[this.mouseX / this.space_grid_multiplier][this.mouseY / this.space_grid_multiplier]);
            if (this.space[this.mouseX / this.space_grid_multiplier][this.mouseY / this.space_grid_multiplier] == this.HOME || this.space[this.mouseX / this.space_grid_multiplier][this.mouseY / this.space_grid_multiplier] == this.BLACK_HOLE) {
                this.game_over = true;
            }
        }
    }

    public void drawCursor() {
        this.fill(255);
        if (this.mouseY < this.height - this.text_box_height - this.space_grid_multiplier) {
            this.rect(this.mouseX - this.crosshair_padding - this.crosshair_length, this.mouseY - this.crosshair_weight / 2, 5.0f, this.crosshair_weight);
            this.rect(this.mouseX + this.crosshair_padding, this.mouseY - this.crosshair_weight / 2, this.crosshair_length, this.crosshair_weight);
            this.rect(this.mouseX - this.crosshair_weight / 2, this.mouseY - this.crosshair_padding - this.crosshair_length, this.crosshair_weight, this.crosshair_length);
            this.rect(this.mouseX - this.crosshair_weight / 2, this.mouseY + this.crosshair_padding, this.crosshair_weight, this.crosshair_length);
        }
        this.fill(0);
    }

    public void fillSpace() {
        int randomSpace = 0;
        int i = 0;
        while (i < this.space_width) {
            int j = 0;
            while (j < this.space_height) {
                randomSpace = PIXEL_SPACE_181028b.round((float)this.random(0.0f, 1000.0f));
                if (randomSpace >= 0 && randomSpace < 900) {
                    this.space[i][j] = this.EMPTY;
                } else if (randomSpace >= 900 && randomSpace < 980) {
                    this.space[i][j] = this.SUN;
                } else if (randomSpace >= 980 && randomSpace < 995) {
                    this.space[i][j] = this.HOME;
                } else if (randomSpace >= 995 && randomSpace <= 1000) {
                    this.space[i][j] = this.BLACK_HOLE;
                }
                this.space_explored[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    public int getSpaceColor(int value) {
        if (value == this.SUN) {
            return this.color(255, 255, 0);
        }
        if (value == this.HOME) {
            return this.color(0, 255, 0);
        }
        if (value == this.BLACK_HOLE) {
            return this.color(255, 0, 0);
        }
        return this.color(63, 63, 255);
    }

    public void updateSpaceText(int value) {
        this.current_text = value == this.SUN ? "You discovered a SUN. Your ENERGY got filled up." : (value == this.HOME ? "You found HOME. Welcome back. Congratulations \u2013 you won the game!" : (value == this.BLACK_HOLE ? "You ended up in a BLACK HOLE \u2013 game over!" : "Just EMPTY Space."));
        this.text_color = this.getSpaceColor(value);
    }

    public void restart() {
        this.game_over = false;
        this.fillSpace();
        this.text_color = this.color(255);
        this.current_text = "Welcome to Space. Find your way back home by clicking on the map";
    }

    public void settings() {
        this.size(800, 400);
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#666666", "--stop-color=#cccccc", "PIXEL_SPACE_181028b"};
        if (passedArgs != null) {
            PApplet.main((String[])PIXEL_SPACE_181028b.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

