int space_width = 1;
int space_height = 1;
int space_grid_multiplier = 4;

int text_box_height = 50;
int text_box_padding = 30;

int crosshair_padding = 10;
int crosshair_length = 5;
int crosshair_weight = 4;

color text_color = color(255,255,255);

int [][] space = new int [space_width][space_height];
Boolean [][] space_explored = new Boolean [space_width][space_height];

int EMPTY = 0;
int SUN = 1;
int HOME = 2;
int BLACK_HOLE = 3;

String current_text = "Welcome to PIXEL-SPACE. Find your way back home by clicking on the map";

Boolean game_over = false;

void setup()
{
  size (800, 400);
  space_width = width/space_grid_multiplier;
  space_height = (height-text_box_height)/space_grid_multiplier;
  space = new int [space_width][space_height];
  space_explored = new Boolean [space_width][space_height];
  
  fill(0);
  noStroke();
  noSmooth();
  noCursor();
  
  fillSpace();
}

void draw ()
{
  background (0);
  
  for (int i = 0; i < space_width; i++)
  {
    for (int j = 0; j < space_height; j++)
    {
      if (space_explored[i][j] == true)
      {
        fill (getSpaceColor(space[i][j]));
          rect(i*space_grid_multiplier,j*space_grid_multiplier,space_grid_multiplier,space_grid_multiplier);
      }
    }
  }
  
  fill(0);
  stroke(255);
  line(0,height - text_box_height, width, height - text_box_height);
  noStroke();
  fill(text_color);
  
  textSize(12);
  text(current_text, text_box_padding, height - text_box_height + text_box_padding);
  fill(255);
  drawCursor();
  fill(0);
  
}

void mouseClicked()
{
  if (game_over)
  {
    restart();
  }
  else
  {
    if (mouseY < height - text_box_height-space_grid_multiplier)
    {
      if (space_explored[mouseX/space_grid_multiplier][mouseY/space_grid_multiplier] == false)
      {
        space_explored[mouseX/space_grid_multiplier][mouseY/space_grid_multiplier] = true;
        updateSpaceText(space[mouseX/space_grid_multiplier][mouseY/space_grid_multiplier]);
        
              
        if (space[mouseX/space_grid_multiplier][mouseY/space_grid_multiplier] == HOME ||
        space[mouseX/space_grid_multiplier][mouseY/space_grid_multiplier] == BLACK_HOLE)
        {
          game_over = true;
        }
      }
    }
  }
}

void drawCursor()
{
  fill(255);
  if (mouseY < height - text_box_height-space_grid_multiplier)
  {
    rect(mouseX-crosshair_padding-crosshair_length, mouseY-crosshair_weight/2, 5, crosshair_weight);
    rect(mouseX+crosshair_padding, mouseY-crosshair_weight/2, crosshair_length, crosshair_weight);
    rect(mouseX-crosshair_weight/2, mouseY-crosshair_padding-crosshair_length, crosshair_weight, crosshair_length);
    rect(mouseX-crosshair_weight/2, mouseY+crosshair_padding, crosshair_weight, crosshair_length);
  }
  fill(0);
}

void fillSpace()
{
  int randomSpace = 0;
  
  for (int i = 0; i < space_width; i++)
  {
    for (int j = 0; j < space_height; j++)
    {
      randomSpace = round(random(0,1000));
      
      if (randomSpace >= 0 && randomSpace < 900)
      {
        space [i][j] = EMPTY;
      }
      else if (randomSpace >= 900 && randomSpace < 980)
      {
        space [i][j] = SUN;
      }
      else if (randomSpace >= 980 && randomSpace < 995)
      {
        space [i][j] = HOME;
      }
      else if (randomSpace >= 995 && randomSpace <= 1000)
      {
        space [i][j] = BLACK_HOLE;
      }
      
      space_explored [i][j] = false;
    }
  }
}

color getSpaceColor(int value)
{
  if (value == SUN) // sun
  {
    return color(255, 255, 0);
  }
  else if (value == HOME) // home
  {
    return color(0, 255, 0);
  }
  else if (value == BLACK_HOLE) // home
  {
    return color(255, 0, 0);
  }
  else // empty
  {
    return color(63, 63, 255);
  }
}

void updateSpaceText(int value)
{
  if (value == SUN) // sun
  {
    current_text = "You discovered a SUN. Your ENERGY got filled up.";
  }
  else if (value == HOME) // home
  {
    current_text = "You found HOME. Welcome back. Congratulations – you won the game!";
  }
  else if (value == BLACK_HOLE) // home
  {
    current_text = "You ended up in a BLACK HOLE – game over!";
  }
  else // empty
  {
    current_text = "Just EMPTY Space.";
  }
  text_color = getSpaceColor(value);
}

void restart() {
  game_over = false;
  fillSpace();
  text_color = color(255);
  current_text = "Welcome to Space. Find your way back home by clicking on the map";
}